unit dotNetAppForm;

{$WARN UNIT_PLATFORM OFF}

interface

uses
  Windows,
  SysUtils,
  System.Text,
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data;

type
  frmPInvoke = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    btnUserName: System.Windows.Forms.Button;
    btnComputerName: System.Windows.Forms.Button;
    btnWindowsDir: System.Windows.Forms.Button;
    btnSystemDir: System.Windows.Forms.Button;
    btnCurrentDir: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure btnUserName_Click(sender: System.Object; e: System.EventArgs);
    procedure btnComputerName_Click(sender: System.Object; e: System.EventArgs);
    procedure btnWindowsDir_Click(sender: System.Object; e: System.EventArgs);
    procedure btnSystemDir_Click(sender: System.Object; e: System.EventArgs);
    procedure btnCurrentDir_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
  public
    constructor Create;
  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(frmPInvoke))]

implementation

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure frmPInvoke.InitializeComponent;
begin
  Self.btnUserName := System.Windows.Forms.Button.Create;
  Self.btnComputerName := System.Windows.Forms.Button.Create;
  Self.btnWindowsDir := System.Windows.Forms.Button.Create;
  Self.btnSystemDir := System.Windows.Forms.Button.Create;
  Self.btnCurrentDir := System.Windows.Forms.Button.Create;
  Self.SuspendLayout;
  // 
  // btnUserName
  // 
  Self.btnUserName.Location := System.Drawing.Point.Create(73, 23);
  Self.btnUserName.Name := 'btnUserName';
  Self.btnUserName.Size := System.Drawing.Size.Create(240, 23);
  Self.btnUserName.TabIndex := 0;
  Self.btnUserName.Text := 'User Name';
  Include(Self.btnUserName.Click, Self.btnUserName_Click);
  // 
  // btnComputerName
  // 
  Self.btnComputerName.Location := System.Drawing.Point.Create(73, 61);
  Self.btnComputerName.Name := 'btnComputerName';
  Self.btnComputerName.Size := System.Drawing.Size.Create(240, 23);
  Self.btnComputerName.TabIndex := 1;
  Self.btnComputerName.Text := 'Computer Name';
  Include(Self.btnComputerName.Click, Self.btnComputerName_Click);
  // 
  // btnWindowsDir
  // 
  Self.btnWindowsDir.Location := System.Drawing.Point.Create(72, 101);
  Self.btnWindowsDir.Name := 'btnWindowsDir';
  Self.btnWindowsDir.Size := System.Drawing.Size.Create(240, 23);
  Self.btnWindowsDir.TabIndex := 2;
  Self.btnWindowsDir.Text := 'Windows Dir';
  Include(Self.btnWindowsDir.Click, Self.btnWindowsDir_Click);
  // 
  // btnSystemDir
  // 
  Self.btnSystemDir.Location := System.Drawing.Point.Create(72, 141);
  Self.btnSystemDir.Name := 'btnSystemDir';
  Self.btnSystemDir.Size := System.Drawing.Size.Create(240, 23);
  Self.btnSystemDir.TabIndex := 3;
  Self.btnSystemDir.Text := 'System Dir';
  Include(Self.btnSystemDir.Click, Self.btnSystemDir_Click);
  // 
  // btnCurrentDir
  // 
  Self.btnCurrentDir.Location := System.Drawing.Point.Create(72, 181);
  Self.btnCurrentDir.Name := 'btnCurrentDir';
  Self.btnCurrentDir.Size := System.Drawing.Size.Create(240, 23);
  Self.btnCurrentDir.TabIndex := 4;
  Self.btnCurrentDir.Text := 'Current Dir';
  Include(Self.btnCurrentDir.Click, Self.btnCurrentDir_Click);
  // 
  // frmPInvoke
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(6, 15);
  Self.ClientSize := System.Drawing.Size.Create(402, 226);
  Self.Controls.Add(Self.btnCurrentDir);
  Self.Controls.Add(Self.btnSystemDir);
  Self.Controls.Add(Self.btnWindowsDir);
  Self.Controls.Add(Self.btnComputerName);
  Self.Controls.Add(Self.btnUserName);
  Self.FormBorderStyle := System.Windows.Forms.FormBorderStyle.FixedSingle;
  Self.Name := 'frmPInvoke';
  Self.StartPosition := System.Windows.Forms.FormStartPosition.CenterScreen;
  Self.Text := '.NET App Using Win32 String Routines';
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure frmPInvoke.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor frmPInvoke.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure frmPInvoke.btnUserName_Click(sender: System.Object; e: System.EventArgs);
var
  UserBuf: StringBuilder;
  UserBufLen: LongWord;
begin
  UserBuf := StringBuilder.Create(2);
  UserBufLen := UserBuf.Capacity;
  Win32Check(GetUserName(UserBuf, UserBufLen));
  MessageBox.Show(UserBuf.ToString)
end;

procedure frmPInvoke.btnComputerName_Click(sender: System.Object; e: System.EventArgs);
var
  ComputerBuf: StringBuilder;
  ComputerBufLen: LongWord;
begin
  //Set max size buffer to ensure success
  ComputerBuf := StringBuilder.Create(MAX_COMPUTERNAME_LENGTH);
  ComputerBufLen := ComputerBuf.Capacity;
  Win32Check(GetComputerName(ComputerBuf, ComputerBufLen));
  MessageBox.Show(ComputerBuf.ToString)
end;

procedure frmPInvoke.btnWindowsDir_Click(sender: System.Object; e: System.EventArgs);
var
  WinDirBuf: StringBuilder;
begin
  WinDirBuf := StringBuilder.Create(MAX_PATH); //Set max size buffer to ensure success
  Win32Check(Bool(GetWindowsDirectory(WinDirBuf, WinDirBuf.Capacity)));
  MessageBox.Show(WinDirBuf.ToString)
end;

procedure frmPInvoke.btnSystemDir_Click(sender: System.Object; e: System.EventArgs);
var
  SysDirBuf: StringBuilder;
begin
  SysDirBuf := StringBuilder.Create(MAX_PATH); //Set max size buffer to ensure success
  Win32Check(Bool(GetSystemDirectory(SysDirBuf, SysDirBuf.Capacity)));
  MessageBox.Show(SysDirBuf.ToString)
end;

procedure frmPInvoke.btnCurrentDir_Click(sender: System.Object; e: System.EventArgs);
var
  CurrDirBuf: StringBuilder;
begin
  CurrDirBuf := StringBuilder.Create(MAX_PATH); //Set max size buffer to ensure success
  Win32Check(Bool(GetCurrentDirectory(CurrDirBuf.Capacity, CurrDirBuf)));
  MessageBox.Show(CurrDirBuf.ToString)
end;

end.
